string GetDescription()
{
	return "This is a very simple latin style arrangement.";
}

int GetRandom(int[] @patches)
{
	return patches[RndInt(0, patches.length()-1)];
}

void Arrange(Song @s)
{
	int bars = s.GetBars();	

	s.AddTrack("Melody", 86,127,64);
	s.AddTrack("Alt Voice", 63,127,64);
	s.AddTrack("Guitar Left", RndInt(30,31),127,20);			
	s.AddTrack("Guitar Right", RndInt(30,31),127,100);			
	s.AddTrack("Guitar Center", RndInt(30,31),127,64);			
	s.AddTrack("Bass", 35,127,64);
	s.AddTrack("Drums", 16,127,64);
	s.AddTrack("Brass", 62,127,64);
	
	int cnt = 0;
	int chorus_cnt = 0;
	
	int intro_start = RndInt(0,1);
	int bass_start = RndInt(0,4);
	
	for (int i = 0; i < s.GetParts(); i++)
	{
		if (s.GetPart(i).GetArrHint() == 0)
		{
			
		}
		else
		{
			if (s.GetPart(i).GetArrHint() == 1 || s.GetPart(i).GetArrHint() == 3)
			{
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,0), 0.7); 
			}
			
			if (s.GetPart(i).GetArrHint() == 2)
			{
				s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,0), 0.8); 
			}
		}
		
		if (s.GetPart(i).GetArrHint() == 3)
		{
			int seed = RndInt(0,32000);
			
			s.AddRenderEvent("Punk Guitar Chords", seed, 4, s.GetPartStartBar(i), s.GetPartEndBar(i), 0, CreateTime(0,0),1.0); 		
			s.SetParam("mode",""+3);
			
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i) , s.GetPartEndBar(i), 2, CreateTime(0,0), 0.8); 
			
			s.AddRenderEvent("Fast Bass", RndInt(0,32000), 5, s.GetPartStartBar(i) , s.GetPartEndBar(i), -1, CreateTime(0,0), 1.0); 
			
			s.AddRenderEvent("Drums - Punk Rock", RndInt(0,32000), 6, s.GetPartStartBar(i) , s.GetPartEndBar(i)-1, 1, CreateTime(0,0), 1.0); 
			s.SetParam("foot & snare" , ""+1);
			s.SetParam("verse hi-hat" , ""+1);
			
			s.AddRenderEvent("Drums - Punk Rock", RndInt(0,32000), 6, s.GetPartEndBar(i)-1, s.GetPartEndBar(i), 1, CreateTime(0,0), 1.0); 
			s.SetParam("transition" , ""+1);
						
			if (chorus_cnt > 1)
			{
				s.AddRenderEvent("Punk Guitar Chords", seed, 7, s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),1.0); 		
				s.SetParam("mode",""+2);
			}
					
			
			chorus_cnt++;	
		}
		else
		{
			int bars_cut = RndInt(1,2);
			
			
			if ( cnt == intro_start)
			{
				s.AddRenderEvent("Drums - Punk Rock", RndInt(0,32000), 6, s.GetPartStartBar(i) , s.GetPartEndBar(i)-bars_cut, 1, CreateTime(0,0), 1.0); 
				s.SetParam("intro hi-hat" , ""+1);
			}
			else if (cnt > intro_start)
			{
				if (RndInt(0,4) != 0)
				{
					s.AddRenderEvent("Drums - Punk Rock", RndInt(0,32000), 6, s.GetPartStartBar(i) , s.GetPartEndBar(i)-bars_cut, 1, CreateTime(0,0), 1.0); 
					s.SetParam("verse hi-hat" , ""+1);
				}
				
				if (RndInt(0,4) != 0)
				{
					s.AddRenderEvent("Drums - Punk Rock", RndInt(0,32000), 6, s.GetPartStartBar(i) , s.GetPartEndBar(i)-bars_cut, 1, CreateTime(0,0), 1.0); 
					s.SetParam("foot & snare" , ""+1);
				}
			}
			
			
			
			s.AddRenderEvent("Drums - Punk Rock", RndInt(0,32000), 6, s.GetPartEndBar(i)-bars_cut, s.GetPartEndBar(i), 1, CreateTime(0,0), 1.0); 
			s.SetParam("transition" , ""+1);
			
			
			s.AddRenderEvent("Punk Guitar Chords", RndInt(0,32000), 4,s.GetPartEndBar(i)-bars_cut, s.GetPartEndBar(i), 0, CreateTime(0,0),1.0); 		
			s.SetParam("mode",""+3);
			
			if (cnt >= bass_start) s.AddRenderEvent("Fast Bass", RndInt(0,32000), 5, s.GetPartStartBar(i), s.GetPartEndBar(i)-1, -1, CreateTime(0,0), 1.0); 
						
			s.AddRenderEvent("Fast Bass", RndInt(0,32000), 5, s.GetPartEndBar(i)-1 , s.GetPartEndBar(i), -1, CreateTime(0,0), 1.0); 
			
			if (cnt == 0)
			{
				s.AddRenderEvent("Punk Guitar Chords", RndInt(0,32000) , 4, s.GetPartStartBar(i), s.GetPartEndBar(i)-bars_cut, 0, CreateTime(0,0),1.0); 		
				s.SetParam("mode",""+RndInt(1,2));
			}
			
			if (cnt == 1)
			{
				s.AddRenderEvent("Punk Guitar Chords", RndInt(0,32000) , 4, s.GetPartStartBar(i), s.GetPartEndBar(i)-bars_cut, 0, CreateTime(0,0),1.0); 		
				s.SetParam("mode",""+RndInt(1,2));
				s.AddRenderEvent("Punk Guitar Chords", RndInt(0,32000) , 2, s.GetPartStartBar(i), s.GetPartEndBar(i)-bars_cut, 0, CreateTime(0,0),0.9); 		
				s.SetParam("mode",""+RndInt(1,2));
			}
						
			else if (cnt > 1)
			{
				bool skip = false;
				if (cnt >= bass_start && cnt > intro_start && RndInt(0,3) == 0) skip = true;
				
				if (!skip)
				{
					s.AddRenderEvent("Punk Guitar Chords", RndInt(0,32000) , 4, s.GetPartStartBar(i), s.GetPartEndBar(i)-bars_cut, 0, CreateTime(0,0),1.0); 		
					s.SetParam("mode",""+RndInt(1,2));
					s.AddRenderEvent("Punk Guitar Chords", RndInt(0,32000) , 2, s.GetPartStartBar(i), s.GetPartEndBar(i)-bars_cut, 0, CreateTime(0,0),0.9); 		
					s.SetParam("mode",""+RndInt(1,2));
					s.AddRenderEvent("Punk Guitar Chords", RndInt(0,32000) , 3, s.GetPartStartBar(i), s.GetPartEndBar(i)-bars_cut, 0, CreateTime(0,0),0.9); 		
					s.SetParam("mode",""+RndInt(1,2));
				}
			}
			
			cnt++;
		}
	}
	
	int intro = RndInt(0,1);
	
	if (intro == 1)
	{
		s.AddRenderEvent("Metronome", RndInt(0,32000), 6, 0, 1, 0, CreateTime(-1,0),0.8); 		
	}
	else if (intro == 0)
	{
		s.AddRenderEvent("Metronome", RndInt(0,32000), 6, 0, 1, 0, CreateTime(-1,0),0.8); 		
		s.SetParam("pitch", ""+51);
	}
	
	s.AddRenderEvent("Drums - Simple Cymbal", 0, 6, bars-1, bars, 1, CreateTime(1,0),1.0); 		
	
}